package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_FAILURE_REASON_LIST
import com.shipsy.ondemand.riderapp.framework.network.model.login.GenericIdName
import com.shipsy.ondemand.riderapp.framework.network.model.login.UndeliveredReason
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.UndeliveredReasonsFetchUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

class UnDeliveredReasonsFetchUseCaseImpl(private val localStore: LocalStore) :
    UndeliveredReasonsFetchUseCase {
    override fun invoke(): List<UndeliveredReason> {
        return getUnDeliveredReasons()
    }

    private fun getUnDeliveredReasons(): List<UndeliveredReason> {
        val json = localStore.getValue(SHARED_PREF_FAILURE_REASON_LIST, "")
        return Json.decodeFromString(ListSerializer(GenericIdName.serializer()), json).map {
            UndeliveredReason(it.id, it.name)
        }
    }
}