package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.login.AppConfigurationData
import com.shipsy.ondemand.riderapp.interactor.repository.FetchAppSettingsRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.SaveAppConfigUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.SyncAppSettingUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.worker.FetchWorkerIdUseCase

class SyncAppSettingUseCaseImpl(
    private val fetchAppSettingsRepository: FetchAppSettingsRepository,
    private val fetchWorkerIdUseCase: FetchWorkerIdUseCase,
    private val saveAppConfigUseCase: SaveAppConfigUseCase
) : SyncAppSettingUseCase {
    override suspend fun invoke(): UseCaseResult<Boolean> {
        val workerId = fetchWorkerIdUseCase.invoke()
        val result = getResult<BaseResponse<AppConfigurationData>> {
            fetchAppSettingsRepository.fetchAppSettings(workerId)
        }
        if (result.isSuccess){
            result.getOrNull()?.let { saveAppConfigUseCase.invoke(it.data!!) }
            return UseCaseResult.success(true)
        }
        return UseCaseResult.failure(result.getErrorData()!!)
    }
}