package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.APP_SETTINGS_RENEW_INTERVAL
import com.shipsy.ondemand.riderapp.domain.const.SETTINGS_UPDATE_TIME
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.ShouldFetchAppSettingsUseCase

class ShouldFetchAppSettingsUseCaseImpl(private val localStore: LocalStore) :
    ShouldFetchAppSettingsUseCase {
    override fun invoke(input: Long): Boolean {
        val lastSettingUpdateTime = localStore.getValue(SETTINGS_UPDATE_TIME, 0L)
        val renewTime = localStore.getValue(APP_SETTINGS_RENEW_INTERVAL, 0L)
        val timeDiff = input - lastSettingUpdateTime
        println("fetch app setting timediff==>$timeDiff  $lastSettingUpdateTime  $renewTime  ${timeDiff > renewTime}")
        return timeDiff > renewTime
    }
}