package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.network.model.login.BatteryInterval
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.SaveBatteryBasedIntervalsUseCase
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

class SaveBatteryBasedIntervalsUseCaseImpl(private val localStore: LocalStore) :
    SaveBatteryBasedIntervalsUseCase {
    override fun invoke(input: ArrayList<BatteryInterval>?): Boolean {

        if (input.isNullOrEmpty()) return false

        val jsonString = Json.encodeToString(input)

        localStore.putValue(BATTERY_BASED_INTERVALS, jsonString)

        input.first().let {

            if (input.isEmpty()) return false
            val jsonString = input

            localStore.putValue(
                GPS_SAMPLING_INTERVAL,
                it.gps_sampling_interval ?: GPS_SAMPLING_LAST_FALLBACK.toLong()
            )
            localStore.putValue(
                APP_SETTINGS_VITAL_SAMPLING_INTERVAL,
                it.vitalstats_sampling_interval ?: GPS_SAMPLING_LAST_FALLBACK.toLong()
            )
            localStore.putValue(
                APP_SETTINGS_VITAL_INTERVAL,
                it.vitalstats_interval ?: GPS_SAMPLING_LAST_FALLBACK.toLong()
            )
            localStore.putValue(
                APP_SETTINGS_RENEW_INTERVAL,
                it.get_settings_interval ?: APP_SETTINGS_RENEW_FALLBACK.toLong()
            )
            localStore.putValue(
                APP_SETTINGS_VITAL_STATS_PAGINATION_LIMIT,
                it.vitalstats_pagination_limit ?: PAGE_LIMIT_FALLBACK
            )
        }
        return true
    }
}