package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_RECEIVER_RELATION_LIST
import com.shipsy.ondemand.riderapp.framework.network.model.login.RelationData
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.ReceiverRelationFetchUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 25/01/23
 */
class ReceiverRelationFetchUseCaseImpl(
    private val localStore: LocalStore
) : ReceiverRelationFetchUseCase {
    override fun invoke(): List<RelationData> {
        val json = localStore.getValue(SHARED_PREF_RECEIVER_RELATION_LIST, "")
        if (json.isEmpty()) return emptyList()
        return Json.decodeFromString(ListSerializer(RelationData.serializer()), json)
    }
}