package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ENABLE_RECEIVER_RELATION
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.IsReceiverRelationEnabledUseCase

/**
 * Created by Kalpesh Kundanani on 25/01/23
 */
class IsReceiverRelationEnabledUseCaseImpl(
    private val localStore: LocalStore
) : IsReceiverRelationEnabledUseCase {
    override fun invoke(): Boolean {
        return localStore.getValue(
            SHARED_PREF_ENABLE_RECEIVER_RELATION,
            false
        )
    }
}