package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.DisableEventType
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ONDEMAND_EVENT_DISABLE_MILLIS
import com.shipsy.ondemand.riderapp.framework.network.model.login.EventDisableDuration
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.GetSwipeDisableTimeUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 07/12/22
 */
class GetSwipeDisableTimeUseCaseImpl(
    private val localStore: LocalStore
): GetSwipeDisableTimeUseCase {
    override fun invoke(input: DisableEventType): Long = getDuration(input)

    private fun getDuration(input: DisableEventType): Long {
        val json = localStore.getValue(SHARED_PREF_ONDEMAND_EVENT_DISABLE_MILLIS, "")
        if (json.isBlank()) return 0

        val list: List<EventDisableDuration> =
            Json.decodeFromString(ListSerializer(EventDisableDuration.serializer()), json)

        val eventDisableDuration = list.firstOrNull { it.name.equals(input.event, ignoreCase = true) } ?: return 0
        return eventDisableDuration.duration
    }
}