package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.BATTERY_BASED_INTERVALS
import com.shipsy.ondemand.riderapp.framework.network.model.login.BatteryInterval
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.GetBatteryBasedIntervalObjectListUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.nativeusecase.FirebaseCrashlyticsUseCase
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

class GetBatteryBasedIntervalObjectListUseCaseImpl(
    private val localStore: LocalStore,
    private val firebaseCrashlyticsUseCase: FirebaseCrashlyticsUseCase
) : GetBatteryBasedIntervalObjectListUseCase {
    override fun invoke(): ArrayList<BatteryInterval> {
        val jsonString = localStore.getValue(BATTERY_BASED_INTERVALS, "")
        return if (jsonString.isEmpty()) {
            ArrayList()
        } else {
            try {
                Json.decodeFromString<ArrayList<BatteryInterval>>(jsonString)
            } catch (e: Exception) {
                firebaseCrashlyticsUseCase.invoke(e)
                ArrayList()
            }
        }
    }
}
