package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_APP_UPDATE
import com.shipsy.ondemand.riderapp.framework.network.model.login.AppUpdate
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.GetAppUpdateUseCase
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 05/02/23
 */
class GetAppUpdateUseCaseImpl(
    private val localStore: LocalStore
): GetAppUpdateUseCase {
    override fun invoke(): AppUpdate? {
        val json = localStore.getValue(SHARED_PREF_APP_UPDATE, "")
        if(json.isBlank()) return null
        return Json.decodeFromString(AppUpdate.serializer(), json)
    }
}