package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.GPS_SAMPLING_INTERVAL
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.FetchGpsSamplingIntervalUseCase

/**
 * Created by Kalpesh Kundanani on 16/09/22
 */
class FetchGpsSamplingIntervalUseCaseImpl(private val localStore: LocalStore): FetchGpsSamplingIntervalUseCase {
    override fun invoke(): Long? {
        val value: Long = localStore.getValue(GPS_SAMPLING_INTERVAL, -1) ?: -1
        return if(value < 0) null else value
    }
}