package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_CALL_LOG_STATUS_LIST
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.FetchCallReasonListUseCase
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.Json

/**
 * Created by Kalpesh Kundanani on 20/01/23
 */
class FetchCallReasonListUseCaseImpl(
    private val localStore: LocalStore
): FetchCallReasonListUseCase {
    override fun invoke(): List<String> {
        val json = localStore.getValue(SHARED_PREF_CALL_LOG_STATUS_LIST, "")
        if (json.isEmpty()) return emptyList()
        return Json.decodeFromString(ListSerializer(String.serializer()), json)
    }
}