package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ONDEMAND_ENABLE_CARD_PAYMENT
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.CheckIfEnableCardPaymentUseCase

/**
 * Created by Kalpesh Kundanani on 06/01/23
 */
class CheckIfEnableCardPaymentUseCaseImpl(
    private val localStore: LocalStore
): CheckIfEnableCardPaymentUseCase {
    override fun invoke(): Boolean {
        return localStore.getValue(
            SHARED_PREF_ONDEMAND_ENABLE_CARD_PAYMENT,
            false
        )
    }
}