package com.shipsy.ondemand.riderapp.domain.usecase.appsettings

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ALLOW_DELIVERY_OTP_SKIP
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.CheckAllowDeliveryOTPValidationUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.CheckAllowOTPValidationUseCase

/**
 * Created by Kalpesh Kundanani on 19/09/22
 */
class CheckAllowDeliveryOTPValidationUseCaseImpl(
    private val localStore: LocalStore,
    private val checkAllowOTPValidationUseCase: CheckAllowOTPValidationUseCase
): CheckAllowDeliveryOTPValidationUseCase {
    override fun invoke(): Boolean {
        val isOTPRequired = checkAllowOTPValidationUseCase.invoke()
        if(!isOTPRequired) return false

        return !localStore.getValue(SHARED_PREF_ALLOW_DELIVERY_OTP_SKIP, false)
    }
}