package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderCurrentState
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.usecase.ShouldUpdateRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateRiderStatusUseCase

class UpdateRiderStatusUseCaseImpl(
    private val localStore: LocalStore,
    private val shouldUpdateRiderStateUseCase: ShouldUpdateRiderStateUseCase
) : UpdateRiderStatusUseCase {
    override suspend fun invoke(input: RiderStateResponse?): Boolean {
        return if (shouldUpdateRiderStateUseCase.invoke(input?.current_state)) {
            saveRiderState(input?.current_state)
            true
        } else
            false
    }

    private fun saveRiderState(currentState: RiderCurrentState?) {
        localStore.putValue(
            RIDER_STATE_RESPONSE_WORKER_STATUS,
            currentState?.worker_status
        )
        localStore.putValue(
            RIDER_STATE_RESPONSE_CHECKED_IN,
            currentState?.checked_in
        )
        localStore.putValue(
            RIDER_STATE_RESPONSE_WORKER_WAITING_STATUS,
            currentState?.waiting_for_slot
        )
        localStore.putValue(
            RIDER_STATE_RESPONSE_IS_ON_BREAK,
            currentState?.is_on_break
        )
        localStore.putValue(
            RIDER_STATE_RESPONSE_TRIP_REFERENCE_NUMBER,
            currentState?.trip_reference_number
        )
    }
}

