package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.helper.UiRefreshNeeded
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateCurrentOrdersUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateRiderStateUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateRiderStatusUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.ShouldFetchRiderStateUseCase

class UpdateRiderStateUseCaseImpl(
    private val updateCurrentOrdersUseCase: UpdateCurrentOrdersUseCase,
    private val updateRiderStatusUseCase: UpdateRiderStatusUseCase,
    private val updateUiRefreshNeeded: UiRefreshNeeded,
    private val database: Database,
    private val shouldFetchRiderStateUseCase: ShouldFetchRiderStateUseCase,
) :
    UpdateRiderStateUseCase {
    override suspend fun invoke(input: RiderStateResponse?): Boolean {

        input?.successful_transaction_ids?.let { removeSuccessfulTransactionIds(it) }
        input?.unsuccessful_transaction_ids?.let {
            incrementRetryCountForUnsuccessfulTransactionIds(
                it
            )
        }
        if (!shouldFetchRiderStateUseCase.invoke()){
            return true
        }
        val riderStatusUpdated = updateRiderStatusUseCase.invoke(input)
        val orderUpdated = updateCurrentOrdersUseCase.invoke(input?.current_state?.current_orders)

        if(orderUpdated) {
            FirebaseEventHandler.logLocalStateUpdate(input)
        }

        val updateUi = riderStatusUpdated || orderUpdated
        println("ui is updated boz $riderStatusUpdated $orderUpdated")
        if (updateUi) {
            println("ui update required")
            updateUiRefreshNeeded.updated()
            FirebaseEventHandler.logUiUpdateEvent(input)
        }

        return updateUi
    }

    private suspend fun removeSuccessfulTransactionIds(ids: List<String>) {
        database.riderStateEventDao.removeSyncedEvent(ids)
    }

    private suspend fun incrementRetryCountForUnsuccessfulTransactionIds(ids: List<String>) {
        database.riderStateEventDao.updateTransactionCount(ids)
    }


}