package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.framework.network.model.login.CurrentOrder
import com.shipsy.ondemand.riderapp.interactor.usecase.ShouldUpdateLocalOrderUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.UpdateCurrentOrdersUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.autoswipe.GoingForPickupAutoSwipeUseCase

class UpdateCurrentOrderUseCaseImpl(
    private val database: Database,
    private val shouldUpdateLocalOrderUseCase: ShouldUpdateLocalOrderUseCase,
    private val goingForPickupAutoSwipeUseCase: GoingForPickupAutoSwipeUseCase
) : UpdateCurrentOrdersUseCase {
    override suspend fun invoke(input: List<CurrentOrder>?): Boolean {
        return try {
            if (shouldUpdateLocalOrderUseCase.invoke(input)) {
                database.currentOrdersDao.insertCurrentOrders(input)

                // whenever data is updated, we needed to
                // update the eligible order for auto swipe of "Going for Pickup"
                goingForPickupAutoSwipeUseCase.invoke(input)
                true
            } else
                false
        } catch (e: Exception) {
            e.printStackTrace()
            false
        }
    }


}