package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.ORG_NAME
import com.shipsy.ondemand.riderapp.domain.const.rider_id
import com.shipsy.ondemand.riderapp.framework.data.NavigationItem
import com.shipsy.ondemand.riderapp.framework.data.RiderStatusState
import com.shipsy.ondemand.riderapp.framework.data.UserLoginState
import com.shipsy.ondemand.riderapp.interactor.usecase.SplashNavigationUserCase

class SplashNavigationUseCaseImpl(private val localStore: LocalStore) :
    SplashNavigationUserCase {
    override suspend fun invoke(input: Any?): UserLoginState {
        return when {
            isUserLoggedIn() -> UserLoginState.Main(NavigationItem.Home(RiderStatusState.CheckedOut))
            isOrganizationDetailExists() -> UserLoginState.Login
            else -> UserLoginState.Organization

        }
    }

    private suspend fun isOrganizationDetailExists(): Boolean {
        return localStore.getValue(ORG_NAME, "").isNotEmpty()
    }

    private suspend fun isUserLoggedIn(): Boolean {
        return localStore.getValue(rider_id, "").isNotEmpty()
    }

}