package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.interactor.usecase.SideNavUserDetailUseCase

class SideNavUserDetailUseCaseImpl(private val localStore: LocalStore) : SideNavUserDetailUseCase {
    override fun invoke(): SideNavUserDetailUseCase.Output {
        return SideNavUserDetailUseCase.Output(getOrgIcon(), getRiderStore(), getRiderEmpId(),getOrgName())
    }

    private fun getOrgIcon(): String {
        return localStore.getValue(ORG_MINI_LOGO, "")
    }

    private fun getRiderStore(): String {
        return localStore.getValue(HUB_CODE, "")
    }

    private fun getRiderEmpId(): String {
        return localStore.getValue(worker_code, "")
    }

    private fun getOrgName(): String {
        return localStore.getValue(ORG_PRETTY_NAME, "")
    }
}