package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderCurrentState
import com.shipsy.ondemand.riderapp.interactor.usecase.ShouldUpdateRiderStateUseCase

class ShouldUpdateRiderStateUseCaseImpl(private val localStore: LocalStore) :
    ShouldUpdateRiderStateUseCase {
    override fun invoke(input: RiderCurrentState?): Boolean {
        val workerStatus = localStore.getValue(
            RIDER_STATE_RESPONSE_WORKER_STATUS,
            ""
        )
        val checkedIn = localStore.getValue(
            RIDER_STATE_RESPONSE_CHECKED_IN,
            false
        )
        val waitingForSlot = localStore.getValue(
            RIDER_STATE_RESPONSE_WORKER_WAITING_STATUS,
            false
        )
        val onBreak = localStore.getValue(
            RIDER_STATE_RESPONSE_IS_ON_BREAK,
            false
        )
        val tripReferenceNumber = localStore.getValue(
            RIDER_STATE_RESPONSE_TRIP_REFERENCE_NUMBER,
            ""
        )

        return (
                workerStatus != input?.worker_status
                || checkedIn != input.checked_in
                || waitingForSlot != (input.waiting_for_slot ?: false)
                || onBreak != input.is_on_break
                || tripReferenceNumber != input.trip_reference_number
                )

    }
}