package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.cache.dao.mapListOrderToCurrentOrder
import com.shipsy.ondemand.riderapp.framework.network.model.login.CurrentOrder
import com.shipsy.ondemand.riderapp.interactor.usecase.ShouldUpdateLocalOrderUseCase

class ShouldUpdateLocalOrderUseCaseImpl(private val database: Database) :
    ShouldUpdateLocalOrderUseCase {
    override suspend fun invoke(input: List<CurrentOrder>?): Boolean {
        val localOrders = getLocalSavedOrders()
        if (localOrders.isEmpty() && input.isNullOrEmpty())
            return false

        if (localOrders.size != input?.size) {
            println("order size is not equal")
            return true
        }

        if (localOrders.size == input.size) {
            input.forEach {
                val order =
                    database.currentOrdersDao.getOrdersByReferenceNumber(it.reference_number) ?: return true
                if(it != order){
                    println("server $it")
                    println("db order  $order")
                    return true
                }
            }
        }
        return false
    }

    private suspend fun getLocalSavedOrders(): List<CurrentOrder> {
        return database.currentOrdersDao.getCurrentOrders().mapListOrderToCurrentOrder()
    }
}