package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.ORG_ID
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.usecase.LoginRiderUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.SdkLoginRiderUseCase

class SdkLoginRiderUseCaseImpl(
    private val localStore: LocalStore,
    private val loginRiderUseCase: LoginRiderUseCase
) : SdkLoginRiderUseCase {

    override suspend fun invoke(input: SdkLoginRiderUseCase.Input): UseCaseResult<Any?> {
        // save org id so that it can be used in headers of following requests.
        localStore.putValue(ORG_ID, input.orgId)

        // login rider.
        return loginRiderUseCase.invoke(input.userLogin)
    }
}