package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.PREF_PASSWORD
import com.shipsy.ondemand.riderapp.domain.const.PREF_USER_NAME
import com.shipsy.ondemand.riderapp.interactor.usecase.SaveUserCredentialsUseCase

/**
 * Created by Kalpesh Kundanani on 04/12/22
 */
class SaveUserCredentialsUseCaseImpl(
    private val localStore: LocalStore
): SaveUserCredentialsUseCase {
    override fun invoke(input: SaveUserCredentialsUseCase.Input): Boolean {
        localStore.putValue(PREF_USER_NAME, input.userName)
        localStore.putValue(PREF_PASSWORD, input.password)
        return true
    }
}