package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.network.model.login.*
import com.shipsy.ondemand.riderapp.interactor.usecase.*
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

class SaveLoginDataUseCaseImpl(
    private val localStore: LocalStore,
    private val saveAppConfigUseCase: SaveAppConfigUseCase,
    private val saveHubDetailUseCase: SaveHubDetailUseCase,
    private val updateRiderStatusUseCase: UpdateRiderStatusUseCase,
) : SaveLoginDataUseCase {
    override suspend fun invoke(input: LoginResponse): Boolean {
        try {
            input.access_token?.let { saveAccessToken(it) }
            input.worker?.let { saveRider(it) }
            input.app_settings?.let { saveAppConfigUseCase.invoke(it) }
            input.hub?.let { saveHubDetailUseCase.invoke(it) }
            input.shift_details?.let { saveCurrentShiftDetail(it) }
            input.firebase_access_token?.let { saveFirebaseAccessToken(it) }
        } catch (e: Exception) {
            return false
        }

        return true
    }

    private fun saveFirebaseAccessToken(firebaseAccessToken: String) {
        localStore.putValue(FIREBASE_TOKEN, firebaseAccessToken)
    }

    private suspend fun saveCurrentShiftDetail(shiftDetails: CurrentShiftDetails) {
        // TODO: to be added in the database.

        shiftDetails.current_state?.let {
            updateRiderStatusUseCase.invoke(RiderStateResponse(
                it,
                listOf(),
                listOf()
            ))
        }
    }

    private fun saveRider(worker: Rider) {
        localStore.putValue(rider_id, worker.id)
        localStore.putValue(rider_name, worker.name)
        localStore.putValue(worker_code, worker.worker_code)
        localStore.putValue(worker_phone, worker.worker_phone)
        localStore.putValue(worker_address, worker.worker_address)
        localStore.putValue(worker_type, worker.worker_type)
    }

    private fun saveAccessToken(accessToken: AccessToken) {
        localStore.putValue(USER_AUTH_TOKEN, accessToken.id)
    }
}