package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.HUB_CODE
import com.shipsy.ondemand.riderapp.domain.const.HUB_LAT
import com.shipsy.ondemand.riderapp.domain.const.HUB_LNG
import com.shipsy.ondemand.riderapp.framework.network.model.login.Hub
import com.shipsy.ondemand.riderapp.interactor.usecase.SaveHubDetailUseCase

class SaveHubDetailUseCaseImpl(private val localStore: LocalStore) : SaveHubDetailUseCase {
    override fun invoke(input: Hub): Boolean {
        println("SaveHubDetailUseCaseImpl: $input")
        localStore.putValue(HUB_CODE, input.code)
        localStore.putValue(HUB_LAT, input.lat)
        localStore.putValue(HUB_LNG, input.lng)
        return true
    }
}