package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.finance.constants.SHARED_PREF_FINANCE_SCREEN_DISPLAY_DATA
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.framework.data.orderhistory.DeliveryStateData
import com.shipsy.ondemand.riderapp.framework.network.model.login.*
import com.shipsy.ondemand.riderapp.interactor.usecase.SaveAppConfigUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.appsettings.batterylevel.SaveBatteryBasedIntervalsUseCase
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json

class SaveAppConfigUseCaseImpl(
    private val localStore: LocalStore,
    private val saveBatteryBasedIntervalsUseCase: SaveBatteryBasedIntervalsUseCase
) : SaveAppConfigUseCase {
    override suspend fun invoke(input: AppConfigurationData): Boolean {
        try {
            saveConfig(input)
//            TODO update time here
        } catch (e: Exception) {
            return false
        }
        return true
    }

    private fun saveConfig(input: AppConfigurationData) {
        localStore.putValue(SHARED_PREF_APP_UPDATE, Json.encodeToString(input.app_update))
        localStore.putValue(
            SHARED_PREF_COD_RECON_PAYMENT_METHODS,
            Json.encodeToString(input.cod_recon_payment_methods)
        )
        localStore.putValue(SHARED_PREF_SHOW_RIDER_PAYOUT_IN_COD, input.show_rider_payout_in_cod)
        localStore.putValue(
            SHARED_PREF_USE_ORDER_LEVEL_DETAILS_FOR_SETTLEMENT,
            input.use_order_level_details_for_settlement
        )
        localStore.putValue(
            SHARED_PREF_RESTRICT_RAISE_COD_IN_RIDERAPP,
            input.restrict_raise_cod_in_riderapp
        )
        saveDeliveryScanConfig(input)
        localStore.putValue(SHARED_PREF_ENABLE_PICKUP_DELIVERY, input.enable_pickup_delivery)
        saveRiderAppIcons(input)
        localStore.putValue(
            SHARED_PREF_FAILURE_REASON_LIST,
            Json.encodeToString(input.failure_reason_list)
        )
        localStore.putValue(SHARED_PREF_GPS_SAMPLING_INTERVAL, input.gps_sampling_interval)
        localStore.putValue(SHARED_PREF_IS_CREATE_EVENT_FILE, input.create_event_file)
        localStore.putValue(SHARED_PREF_EVENT_FILE_INTERVAL, input.event_file_interval)
        localStore.putValue(SHARED_PREF_ONDEMAND_SHOW_RETRY, input.ondemand_show_retry)
        localStore.putValue(
            SHARED_PREF_ONDEMAND_SHOW_COLOR_CODING_FOR_ORDER_SEQUENCE,
            input.ondemand_show_color_coding_for_order_sequence
        )
        localStore.putValue(SHARED_PREF_SHOW_RIDER_ID_CARD, input.show_rider_id_card)
        localStore.putValue(
            SHARED_PREF_RESTRICT_RIDER_CHECKOUT_IN_ASSIGNED_STATE,
            input.restrict_rider_checkout_in_assigned_state
        )
        localStore.putValue(
            SHARED_PREF_VERIFY_BEFORE_MARKING_PICKUP_COMPLETED,
            input.verify_before_marking_pickup_completed
        )
        localStore.putValue(SHARED_PREF_DISABLE_FILE_UPLOAD, input.disable_file_upload)
        localStore.putValue(
            SHARED_PREF_RIDERSTATE_POLLING_TIME_SECONDS,
            input.riderstate_polling_time_seconds
        )
        localStore.putValue(
            SHARED_PREF_COD_RECONCILATION_HUBS,
            Json.encodeToString(input.cod_reconcilation_hubs)
        )
        localStore.putValue(SHARED_PREF_IS_ONDUTY, input.onduty)
        saveBatteryBasedIntervalsUseCase.invoke(input.battery_based_intervals)

        localStore.putValue(SHARED_PREF_STATUS_SEND_INTERVAL_MIN, input.status_send_interval_min)
        localStore.putValue(SHARED_PREF_STATUS_SEND_INTERVAL_MAX, input.status_send_interval_max)
        localStore.putValue(SHARED_PREF_STATUS_SEND_DISTANCE, input.status_send_distance)
        localStore.putValue(SHARED_PREF_GPS_CACHE_EXPIRY, input.gps_cache_expiry)
        localStore.putValue(
            SHARED_PREF_UPDATE_FIREBASE_COORDINATES,
            input.update_firebase_coordinates
        )
        input.ondemand_back_to_store_config?.let {
            localStore.putValue(
                SHARED_PREF_ONDEMAND_BACK_TO_STORE_CONFIG,
                it.distance_in_m
            )
        }
        localStore.putValue(SHARED_PREF_ONDEMAND_SHOW_PERFORMANCE, input.ondemand_show_performance)
        localStore.putValue(SHARED_PREF_SHOW_RIDER_PAYOUT, input.show_rider_payout)
        localStore.putValue(SHARED_PREF_GEOFENCE_CONFIG, Json.encodeToString(input.geofence_config))
        localStore.putValue(
            SHARED_PREF_RECEIVER_RELATION_LIST,
            Json.encodeToString(input.receiver_relation_list)
        )
        localStore.putValue(
            SHARED_PREF_IS_ENABLE_ONDEMAND_CUSTOM_NOTIFICATION_SOUND,
            input.enable_ondemand_custom_notification_sound
        )
        localStore.putValue(
            SHARED_PREF_NOTIFICATION_SOUND_CONFIG,
            Json.encodeToString(input.notification_sound_config)
        )
        localStore.putValue(SHARED_PREF_IS_ALLOW_CASH_EDIT, input.allow_cash_edit)
        localStore.putValue(SHARED_PREF_RIDER_APP_TIME_ZONE, input.timezone ?: "Asia/Kolkata")
        localStore.putValue(SHARED_PREF_CUSTOMER_CARE_PHONE, input.customer_care_phone)
        localStore.putValue(SHARED_PREF_SHOW_WORKER_CREDIT_MODULE, input.show_worker_credit_module)
        localStore.putValue(
            SHARED_PREF_ONDEMAND_ENABLE_UPI_PAYMENT,
            input.ondemand_enable_upi_payment
        )
        localStore.putValue(SHARED_PREF_IS_FIREBASE_LIVE_TRACKING, input.firebase_live_tracking)
        localStore.putValue(
            SHARED_PREF_IS_SHOW_SHIFTS_FOR_ALL_RIDERS_ONDEMAND,
            input.show_shifts_for_all_riders_ondemand
        )
        localStore.putValue(
            SHARED_PREF_SHOW_PICKED_UP_IN_DELIVERY_FLOW,
            input.show_picked_up_in_delivery_flow
        )
        localStore.putValue(
            SHARED_PREF_ONDEMAND_EVENT_DISABLE_MILLIS,
            Json.encodeToString(input.ondemand_event_disable_millis)
        )
        localStore.putValue(SHARED_PREF_SUSPICIOUS_EVENT_DISTANCE, input.suspicious_event_distance)
        localStore.putValue(
            SHARED_PREF_ON_DEMAND_CHECK_IN_DISTANCE,
            input.ondemand_check_in_distance
        )
        localStore.putValue(
            SHARED_PREF_ONDEMAND_RESET_STATE_EPOCH,
            input.ondemand_reset_state_epoch
        )
        localStore.putValue(
            SHARED_PREF_TSG_DISCOUNT_REASONS,
            Json.encodeToString(input.tsg_discount_reasons)
        )
        localStore.putValue(
            SHARED_PREF_CALL_LOG_STATUS_LIST,
            Json.encodeToString(input.call_log_status_list)
        )
        localStore.putValue(
            SHARED_PREF_PARTIAL_DELIVERY_REASON_LIST,
            Json.encodeToString(input.partial_delivery_reason_list)
        )
        localStore.putValue(SHARED_PREF_DEFAULT_TSG_MIN_DURATION, input.default_tsg_min_duration)
        localStore.putValue(SHARED_PREF_DEFAULT_TSG_MAX_DURATION, input.default_tsg_max_duration)
        localStore.putValue(
            SHARED_PREF_LATE_DISCOUNT_REASONS,
            Json.encodeToString(input.late_discount_reasons)
        )
        localStore.putValue(SHARED_PREF_DEFAULT_LATE_DISCOUNT, input.default_late_discount)
        localStore.putValue(SHARED_PREF_DEFAULT_LATE_MIN_DURATION, input.default_late_min_duration)
        localStore.putValue(SHARED_PREF_DEFAULT_LATE_MAX_DURATION, input.default_late_max_duration)
        localStore.putValue(
            SHARED_PREF_SHOW_ONDEMAND_UNDELIVERED_TAB,
            input.show_ondemand_undelivered_tab
        )
        localStore.putValue(
            SHARED_PREF_SHOW_ONDEMAND_HELPDESK_NOTIFS,
            input.show_ondemand_helpdesk_notifs
        )
        localStore.putValue(SHARED_PREF_CURRENCY_SYMBOL, input.currency_symbol)
        localStore.putValue(
            SHARED_PREF_ONDEMAND_ENABLE_COD_FILE_UPLOAD,
            input.ondemand_enable_cod_file_upload
        )
        localStore.putValue(SHARED_PREF_AAROGYA_SETU_APP_CHECK, input.aarogya_setu_app_check)
        localStore.putValue(SHARED_PREF_AAROGYA_SETU_APP_LINK, input.aarogya_setu_app_link)
        localStore.putValue(SHARED_PREF_UPI_PAYMENT_PROVIDER, input.upi_payment_provider)
        localStore.putValue(SHARED_PREF_UPI_PAYMENT_EXPIRY_TIME, input.upi_payment_expiry_time)
        localStore.putValue(SHARED_PREF_UPI_PAYMENT_ICON_URL, input.upi_payment_icon_url)
        localStore.putValue(
            SHARED_PREF_DO_NOT_RESTRICT_SHIFT_CHECKIN,
            input.do_not_restrict_shift_checkin
        )
        localStore.putValue(SHARED_PREF_SHOW_SHIFTS_ONDEMAND, input.show_shifts_ondemand)
        localStore.putValue(SHARED_PREF_SHOW_RIDER_LOGIN_HISTORY, input.show_rider_login_history)
        localStore.putValue(SHARED_PREF_SHOW_ORDER_REVIEW_SCREEN, input.show_order_review_screen)
        localStore.putValue(
            SHARED_PREF_ENABLE_ONDEMAND_PAYTM_QR_PERSISTENCE,
            input.enable_ondemand_paytm_qr_persistence
        )
        localStore.putValue(
            SHARED_PREF_ALLOW_CALL_LOG_IN_RIDER_APP,
            input.allow_call_log_in_rider_app
        )
        localStore.putValue(
            SHARED_PREF_SHOW_TERMS_AND_CONDITION_CHECK_AT_LOGIN,
            input.show_terms_and_condition_check_at_login
        )
        localStore.putValue(
            SHARED_PREF_RIDER_TERMS_AND_CONDITIONS_LATEST_VERSION,
            input.rider_terms_and_conditions_latest_version
        )
        localStore.putValue(
            SHARED_PREF_RIDER_TERMS_AND_CONDITIONS,
            input.rider_terms_and_conditions
        )
        localStore.putValue(
            SHARED_PREF_ONDEMAND_NOTIFICATION_SOUND,
            input.ondemand_notification_sound
        )
        localStore.putValue(SHARED_PREF_SHOW_RIDER_WEEKOFFS, input.show_rider_weekoffs)
        saveAppFlowConfig(input.app_flow_config)
        localStore.putValue(SHARED_PREF_ALLOW_OTP_VALIDATION, input.allow_otp_validation)
        localStore.putValue(SHARED_PREF_CHILD_HUB_LIST, Json.encodeToString(input.child_hub_list))
        localStore.putValue(
            SHARED_PREF_ALLOW_CHECKIN_FROM_CHILD_HUBS,
            input.allow_checkin_from_child_hubs
        )
        localStore.putValue(
            SHARED_PREF_IS_BATTERY_USAGE_RESTRICTED,
            input.is_battery_usage_restricted
        )
        localStore.putValue(
            SHARED_PREF_MESSAGE_ON_RIDER_ELIGIBLE_COHORT,
            input.message_on_rider_eligible_cohort
        )
        localStore.putValue(
            SHARED_PREF_MESSAGE_ON_RIDER_INELIGIBLE_COHORT,
            input.message_on_rider_ineligible_cohort
        )
        localStore.putValue(
            SHARED_PREF_COHORT_CHANGE_MESSAGE_POP_UP,
            input.cohort_change_message_pop_up
        )
        localStore.putValue(
            SHARED_PREF_ONDEMAND_VEHICLE_QRCODE_SCAN,
            input.ondemand_vehicle_qrcode_scan
        )
        localStore.putValue(SHARED_PREF_ALLOW_S_3_SOFT_UPDATE, input.ALLOW_S3_SOFT_UPDATE)
        input.shift_management?.let {
            localStore.putValue(
                SHARED_PREF_SHIFT_MANAGEMENT,
                it.is_planned_shift_required
            )
        }
        localStore.putValue(SHARED_PREF_SKIP_VEHICLE_SCAN_TIMEOUT, input.skip_vehicle_scan_timeout)
        localStore.putValue(
            SHARED_PREF_ONDEMAND_ENABLE_CARD_PAYMENT,
            input.ondemand_enable_card_payment
        )
        localStore.putValue(SHARED_PREF_HIDE_ADDRESS_BEFORE_OFD, input.hide_address_before_ofd)
        localStore.putValue(
            SHARED_PREF_SKIP_VEHICLE_SCAN_REASON_LIST,
            Json.encodeToString(input.skip_vehicle_scan_reason_list)
        )
        localStore.putValue(
            SHARED_PREF_ORDER_INSTRUCTIONS,
            Json.encodeToString(input.order_instructions)
        )
        localStore.putValue(SHARED_PREF_PL_1, input.pl1)
        localStore.putValue(SHARED_PREF_PL_2, Json.encodeToString(input.pl2))
        localStore.putValue(SHARED_PREF_CHECKOUT_FOR_FAKE_GPS, input.checkout_for_fake_gps)
        localStore.putValue(
            SHARED_PREF_UNDELIVERED_VALIDATIONS,
            Json.encodeToString(input.undelivered_validations)
        )
        localStore.putValue(SHARED_PREF_ALLOW_DELIVERY_OTP_SKIP, input.allow_delivery_otp_skip)
        localStore.putValue(
            SHARED_PREF_ALLOW_PICKUP_WITHOUT_ORDER_DETAILS,
            input.allow_pickup_without_order_details
        )
        localStore.putValue(
            SHARED_PREF_ENABLE_CARD_TRANSACTION_ID,
            input.enable_card_transaction_id
        )
        savePickupConfig(input.ondemand_pickup_config)
        localStore.putValue(SHARED_PREF_ALLOW_PARTIAL_DELIVERY, input.allow_partial_delivery)

        //finance module configs
        saveFinanceModuleConfigs(input)

        //firebase database URL
        localStore.putValue(SHARED_PREF_FIREBASE_DATABASE_URL, input.firebase_database_url)
    }

    private fun saveFinanceModuleConfigs(input: AppConfigurationData) {
        input.finance_screen_data_to_show?.let { data ->
            data.overview?.let {
                localStore.putValue(
                    SHARED_PREF_FINANCE_SCREEN_DISPLAY_DATA,
                    Json.encodeToString(it)
                )
            }
        }
    }

    private fun saveRiderAppIcons(input: AppConfigurationData) {
        val iconList = input.rider_app_icons_config ?: return
        val map: HashMap<String, DeliveryStateData> = HashMap()
        for (deliveryState in iconList) {
            deliveryState.type?.let {
                map[it] = deliveryState
            }
        }
        localStore.putValue(
            SHARED_PREF_RIDER_APP_ICONS_CONFIG,
            Json.encodeToString(map)
        )
    }

    private fun saveAppFlowConfig(deliveryProcesses: ArrayList<AppFlowConfig>?) {
        if (!deliveryProcesses.isNullOrEmpty()) {
            val appFlowConfig: AppFlowConfig =
                deliveryProcesses.get(0)
            appFlowConfig.delivery_process_config?.forEach { process ->
                if (process.name != null && process.name == "success_recipient_relationship" && process.input != null && process.input == "mandatory") {
                    localStore.putValue(SHARED_PREF_ENABLE_RECEIVER_RELATION, true)
                }
            }
        }
    }

    private fun savePickupConfig(input: PickupConfig?) {
        if (input == null) return
        localStore.putValue(PICKUP_CONFIG_ENABLE_PICKING_FLOW, input.enable_picking_flow)
        localStore.putValue(PICKUP_CONFIG_SCAN_BAGS_BARCODE, input.scan_bags_barcode)
        localStore.putValue(PICKUP_CONFIG_ALLOW_SCAN, input.allow_scan)
        localStore.putValue(PICKUP_CONFIG_ALLOW_MANUAL_ENTRY, input.allow_manual_entry)
        localStore.putValue(PICKUP_CONFIG_ALLOW_MANUAL_PICKUP, input.allow_manual_pickup)
        localStore.putValue(
            PICKUP_CONFIG_ALLOW_PARTIAL_ORDER_PICKUP,
            input.allow_partial_order_pickup
        )
        localStore.putValue(PICKUP_CONFIG_FAILURE_REASON_REQUIRED, input.failure_reason_required)
        localStore.putValue(PICKUP_CONFIG_FAILURE_IMAGE_REQUIRED, input.failure_image_required)
        localStore.putValue(PICKUP_CONFIG_SCAN_TIMER_DURATION, input.scan_timer_duration)
        localStore.putValue(PICKUP_CONFIG_DISABLE_PICKUP_FAILED, input.disable_pickup_failed)
        savePickupReasons(input.reasons)
    }

    private fun savePickupReasons(reasons: PickupProcessReasonsList?) {
        if (reasons == null) return
        localStore.putValue(
            SHARED_PREF_SCAN_FAILED_REASON_LIST,
            Json.encodeToString(reasons.scan_failed)
        )
        localStore.putValue(
            SHARED_PREF_MANUAL_ENTRY_REASON_LIST,
            Json.encodeToString(reasons.manual_entry_failed)
        )
        localStore.putValue(
            SHARED_PREF_MANUAL_PICKUP_REASON_LIST,
            Json.encodeToString(reasons.manual_pickup)
        )
        localStore.putValue(
            SHARED_PREF_NOT_MANUAL_PICKUP_REASON_LIST,
            Json.encodeToString(reasons.not_manual_pickup)
        )
    }

    private fun saveDeliveryScanConfig(input: AppConfigurationData) {
        val deliveryScanFlowConfig = input.ondemand_delivery_config ?: return
        localStore.putValue(
            SHARED_PREF_ENABLE_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.enable_delivery_scan_flow
        )
        localStore.putValue(
            SHARED_PREF_SCAN_BAGS_BARCODE_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.scan_bags_barcode
        )
        localStore.putValue(
            SHARED_PREF_ALLOW_SCAN_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.allow_scan
        )
        localStore.putValue(
            SHARED_PREF_ALLOW_MANUAL_ENTRY_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.allow_manual_entry
        )
        localStore.putValue(
            SHARED_PREF_ALLOW_MANUAL_DELIVERY,
            deliveryScanFlowConfig.allow_manual_delivery
        )
        localStore.putValue(
            SHARED_PREF_ALLOW_PARTIAL_ORDER_DELIVERY_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.allow_partial_order_delivery
        )
        localStore.putValue(
            SHARED_PREF_FAILURE_REASON_REQUIRED_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.failure_reason_required
        )
        localStore.putValue(
            SHARED_PREF_FAILURE_IMAGE_REQUIRED_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.failure_image_required
        )
        localStore.putValue(
            SHARED_PREF_SCAN_TIMER_DURATION_IN_DELIVERY_SCAN_FLOW,
            deliveryScanFlowConfig.scan_timer_duration
        )
        saveDeliveryScanReasonsLists(deliveryScanFlowConfig)
    }

    private fun saveDeliveryScanReasonsLists(deliveryScanFlowConfig: DeliveryScanFlowConfig) {
        val reasonsType: DeliveryScanFlowReasonList? = deliveryScanFlowConfig.reasons
        if (reasonsType != null) {
            val scanFailedReasonList = reasonsType.scan_failed
            if (scanFailedReasonList != null) localStore.putValue(
                SHARED_PREF_SCAN_FAILED_REASON_LIST_IN_DELIVERY_SCAN_FLOW,
                Json.encodeToString(scanFailedReasonList)
            )

            val manualEntryFailedList = reasonsType.manual_entry_failed
            if (manualEntryFailedList != null) localStore.putValue(
                SHARED_PREF_MANUAL_ENTRY_REASON_LIST_IN_DELIVERY_SCAN_FLOW,
                Json.encodeToString(manualEntryFailedList)
            )

            val manualDeliveryList = reasonsType.manual_delivery
            if (manualDeliveryList != null) localStore.putValue(
                SHARED_PREF_MANUAL_DELIVERY_REASON_LIST,
                Json.encodeToString(
                    manualDeliveryList
                )
            )

            val notManualDeliveryList = reasonsType.not_manual_delivery
            if (notManualDeliveryList != null) localStore.putValue(
                SHARED_PREF_NOT_MANUAL_DELIVERY_REASON_LIST,
                Json.encodeToString(
                    notManualDeliveryList
                )
            )
        }
    }
}