package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.domain.helper.CommonFlow
import com.shipsy.ondemand.core.domain.helper.asCommonFlow
import com.shipsy.ondemand.riderapp.framework.data.RiderStatusState
import com.shipsy.ondemand.riderapp.interactor.helper.UiRefreshNeeded
import com.shipsy.ondemand.riderapp.interactor.usecase.RiderStateUpdatedUseCase
import com.shipsy.ondemand.riderapp.interactor.usecase.riderstate.RiderCurrentStateUseCase
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.flow.flow

class RiderStateUpdatedUseCaseImpl(private val riderCurrentStateUseCase: RiderCurrentStateUseCase) :
    RiderStateUpdatedUseCase, UiRefreshNeeded {
    private val stateUpdateChannel = Channel<Boolean>()
    override fun invoke(): CommonFlow<RiderStatusState> = flow {
        for (update in stateUpdateChannel) {
            println("update rider state")
            emit(riderCurrentStateUseCase.invoke(RiderCurrentStateUseCase.Input()))
        }
    }.asCommonFlow()


    override suspend fun updated() {
        println("update state")
        stateUpdateChannel.send(true)
    }
}

