package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.framework.network.getResult
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.core.framework.network.UseCaseResult
import com.shipsy.ondemand.riderapp.interactor.data.OrgLoginResponse
import com.shipsy.ondemand.riderapp.interactor.repository.OrgRepository
import com.shipsy.ondemand.riderapp.interactor.usecase.OrganizationLoginUseCase

class OrganizationLoginUseCaseImpl(
    private val localStore: LocalStore,
    private val orgRepository: OrgRepository
) : OrganizationLoginUseCase {
    override suspend fun invoke(input: OrganizationLoginUseCase.Input): UseCaseResult<OrgLoginResponse> {
        val response =
            getResult<OrgLoginResponse> { orgRepository.makeOrgLoginRequest(input.orgName) }

        if (response.isSuccess)
            saveOrgDetails(response.getOrNull()!!)

        return response
    }


    private suspend fun saveOrgDetails(orgLoginResponse: OrgLoginResponse) {
        localStore.putValue(ORG_ID, orgLoginResponse.id)
        localStore.putValue(ORG_NAME, orgLoginResponse.name)
        localStore.putValue(ORG_LIGHT_LOGO, orgLoginResponse.lightLogo)
        localStore.putValue(ORG_MINI_LOGO, orgLoginResponse.miniLogo)
        localStore.putValue(ORG_PRETTY_NAME, orgLoginResponse.displayName)
    }
}