package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.riderapp.domain.orderstatus.OrderStatus
import com.shipsy.ondemand.riderapp.interactor.usecase.OrderPriorityUseCase

class OrderPriorityUseCaseImpl : OrderPriorityUseCase {
    override fun invoke(input: OrderStatus): Int? {
        return when (input) {
            OrderStatus.PICKUP_AWAITED -> 0
            OrderStatus.PICKED_UP -> 1
            OrderStatus.REACHED_GATE -> 1
            OrderStatus.RTO_REACHED_GATE -> 1
            else -> null
        }
    }
}