package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.domain.SuspendingUseCase
import com.shipsy.ondemand.riderapp.cache.Database
import com.shipsy.ondemand.riderapp.shared.cache.CurrentOrders

class OrderFetchUseCaseImpl(private val appDatabase: Database) :
    SuspendingUseCase<Any?, List<CurrentOrders>> {
    override suspend fun invoke(input: Any?): List<CurrentOrders> {
        val order = appDatabase.currentOrdersDao.getCurrentOrders()
        order.forEach {
            println(it)
        }
        return order
    }
}