package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.IS_LOGOUT_BECAUSE_UNAUTHORISED
import com.shipsy.ondemand.riderapp.interactor.usecase.MarkLogoutBecauseUnauthorisedUseCase

/**
 * Created by Kalpesh Kundanani on 04/12/22
 */
class MarkLogoutBecauseUnauthorisedUseCaseImpl(
    private val localStore: LocalStore
) : MarkLogoutBecauseUnauthorisedUseCase {
    override fun invoke(input: Boolean): Boolean {
        localStore.putValue(IS_LOGOUT_BECAUSE_UNAUTHORISED, input)
        return true
    }
}