package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.HeaderProviderUseCase
import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.*
import com.shipsy.ondemand.riderapp.interactor.usecase.HeaderNativeUseCase

class HeaderProviderUseCaseImpl(
    private val localStore: LocalStore,
    private val headerNativeUseCase: HeaderNativeUseCase
) : HeaderProviderUseCase {
    override fun invoke(input: Any?): Map<String, Any?> {
        val nativeDetails = headerNativeUseCase.invoke()
        val headers = HashMap<String, Any?>()
        headers[HEADER_USER_ID] = localStore.getValue(rider_id, "")
        headers[ACCESS_TOKEN] = localStore.getValue(USER_AUTH_TOKEN, "")
        headers[CONTENT_TYPE] = CONTENT_TYPE_VALUE
        headers[ORGANISATION_ID] = localStore.getValue(ORG_ID, "")
        headers[APP_VERSION] = nativeDetails.appVersion
        headers[APP_FLAVOR] = nativeDetails.appFlavour
        headers[APP_TYPE] = nativeDetails.appType
        headers[ACCEPT_LANGUAGE] = nativeDetails.appLanguage
        headers[APP_PACKAGE_NAME] = nativeDetails.appPackageName
        println("test : $headers :: $nativeDetails")
        return headers
    }
}