package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.IS_LOGOUT_BECAUSE_UNAUTHORISED
import com.shipsy.ondemand.riderapp.domain.const.PREF_PASSWORD
import com.shipsy.ondemand.riderapp.domain.const.PREF_USER_NAME
import com.shipsy.ondemand.riderapp.interactor.usecase.GetLoginScreenStateUseCase

/**
 * Created by Kalpesh Kundanani on 04/12/22
 */
class GetLoginScreenStateUseCaseImpl(
    private val localStore: LocalStore
): GetLoginScreenStateUseCase {
    override fun invoke(): GetLoginScreenStateUseCase.Output {
        return getState()
    }

    private fun getState(): GetLoginScreenStateUseCase.Output = GetLoginScreenStateUseCase.Output(
        localStore.getValue(IS_LOGOUT_BECAUSE_UNAUTHORISED, false),
        localStore.getValue(PREF_USER_NAME, ""),
        localStore.getValue(PREF_PASSWORD, ""),
    )
}