package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.FIREBASE_TOKEN
import com.shipsy.ondemand.riderapp.domain.const.USER_REGISTERED_STATUS
import com.shipsy.ondemand.riderapp.interactor.usecase.FirebaseAuthenticationUseCase

class FirebaseAuthenticationUseCaseImpl(private val localStore: LocalStore) :
    FirebaseAuthenticationUseCase {
    override fun invoke(): FirebaseAuthenticationUseCase.Output {
        return FirebaseAuthenticationUseCase.Output(getFirebaseToken(), isUserRegistered())
    }

    private fun getFirebaseToken() = localStore.getValue(FIREBASE_TOKEN, "")

    private fun isUserRegistered() =
        localStore.getValue(FIREBASE_TOKEN, "").isNotBlank() && !localStore.getValue(
            USER_REGISTERED_STATUS,
            false
        )
}