package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.SHARED_PREF_ADS_ID
import com.shipsy.ondemand.riderapp.interactor.usecase.FetchSavedAdsIdUseCase

/**
 * Created by Kalpesh Kundanani on 08/02/23
 */
class FetchSavedAdsIdUseCaseImpl(
    private val localStore: LocalStore
): FetchSavedAdsIdUseCase {
    override fun invoke(): String? {
        val adsId = localStore.getValue(SHARED_PREF_ADS_ID, "")
        if(adsId.isBlank()) return null
        return adsId
    }
}