package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.ORG_ID
import com.shipsy.ondemand.riderapp.domain.const.ORG_LIGHT_LOGO
import com.shipsy.ondemand.riderapp.domain.const.ORG_PRETTY_NAME
import com.shipsy.ondemand.riderapp.interactor.usecase.FetchOrgDetailUseCase

class FetchOrgDetailUseCaseImpl(private val localStore: LocalStore) : FetchOrgDetailUseCase {
    override suspend fun invoke(input: Any): FetchOrgDetailUseCase.OrgDetails {
        val orgId = localStore.getValue(ORG_ID, "")
        val orgName = localStore.getValue(ORG_PRETTY_NAME, "")
        val orgLogo = localStore.getValue(ORG_LIGHT_LOGO, "")
        return FetchOrgDetailUseCase.OrgDetails(orgId, orgName, orgLogo)
    }
}