package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.HUB_CODE
import com.shipsy.ondemand.riderapp.domain.const.HUB_LAT
import com.shipsy.ondemand.riderapp.domain.const.HUB_LNG
import com.shipsy.ondemand.riderapp.framework.network.model.login.Hub
import com.shipsy.ondemand.riderapp.interactor.usecase.FetchHubDetailUseCase

class FetchHubDetailUseCaseImpl(private val localStore: LocalStore) : FetchHubDetailUseCase {
    override fun invoke(): Hub {
        return Hub(
            localStore.getValue(HUB_CODE, ""),
            localStore.getValue(HUB_LAT, 0.0),
            localStore.getValue(HUB_LNG, 0.0)
        )
    }
}