package com.shipsy.ondemand.riderapp.domain.usecase

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.domain.const.HUB_CODE
import com.shipsy.ondemand.riderapp.domain.const.ORG_LIGHT_LOGO
import com.shipsy.ondemand.riderapp.domain.const.ORG_MINI_LOGO
import com.shipsy.ondemand.riderapp.interactor.usecase.CheckInDetailUseCase

class CheckInDetailUseCaseImpl(private val localStore: LocalStore) : CheckInDetailUseCase {
    override fun invoke(): CheckInDetailUseCase.Output {
        return CheckInDetailUseCase.Output(getOrgIcon(), getRiderStore())
    }

    private fun getOrgIcon(): String {
        return localStore.getValue(ORG_MINI_LOGO, "")
    }

    private fun getRiderStore(): String {
        return localStore.getValue(HUB_CODE, "")
    }
}