package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.data.sdk.SDKMasterDataFetchResponse
import com.shipsy.ondemand.riderapp.framework.data.sdk.SdkAppSettings
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.SDKRepository

/**
 * Created by Kalpesh Kundanani on 26/09/22
 */
class SDKRepositoryImpl(private val networkClient: NetworkClient) : SDKRepository {
    override suspend fun sdkMasterDataFetch(): BaseResponse<SDKMasterDataFetchResponse> {
        return networkClient.sdkMasterDataFetch()
    }
    override suspend fun checkSdkHealth(): BaseResponse<SdkAppSettings> {
        return networkClient.checkSdkHealth()
    }
}