package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.core.interactor.LocalStore
import com.shipsy.ondemand.riderapp.framework.network.model.UserLogin
import com.shipsy.ondemand.riderapp.framework.network.model.login.LoginResponse
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.RiderLoginRepository

class RiderLoginRepoImpl(
    private val networkClient: NetworkClient,
    private val localStore: LocalStore
) :
    RiderLoginRepository {
    override suspend fun loginRider(userLogin: UserLogin): LoginResponse {
        return networkClient.login(userLogin)
    }

}