package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.data.loginhistory.LoginHistoryData
import com.shipsy.ondemand.riderapp.framework.data.orderhistory.OrderHistoryData
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.WithdrawRequestModel
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionData
import com.shipsy.ondemand.riderapp.framework.network.model.transactionhistory.TransactionHistoryRequestBody
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.HistoryRepository

/**
 * Created by Kalpesh Kundanani on 22/08/22
 */
class HistoryRepositoryImpl(private val client: NetworkClient) : HistoryRepository {
    override suspend fun getOrderHistory(
        fromDate: String,
        toDate: String
    ): BaseResponse<OrderHistoryData> = client.getOrderHistory(fromDate, toDate)

    override suspend fun getLoginHistory(ofDate: String): BaseResponse<LoginHistoryData> =
        client.getLoginHistory(ofDate)

    override suspend fun fetchRejectedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData> =
        client.fetchRejectedRequests(body)

    override suspend fun fetchApprovedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData> =
        client.fetchApprovedRequests(body)

    override suspend fun fetchRaisedRequests(body: TransactionHistoryRequestBody): BaseResponse<TransactionData> =
        client.fetchRaisedRequests(body)

    override suspend fun postWithdrawRequest(body: WithdrawRequestModel): BaseResponse<Boolean?> =
        client.postWithdrawRequest(body)
}