package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.file.ImageTypeModel
import com.shipsy.ondemand.riderapp.framework.network.model.file.UploadDocumentsData
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.FetchUrlForStorageRepository


/**
 * Created by Kalpesh Kundanani on 09/09/22
 */
class FetchUrlForStorageRepositoryImpl(private val networkClient: NetworkClient) :
    FetchUrlForStorageRepository {
    override suspend fun getUrlForStorage(model: ImageTypeModel): BaseResponse<UploadDocumentsData> {
        return networkClient.getUrlForStorage(model)
    }
}