package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.order.UpcomingOrdersModel
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.FetchUpcomingOrdersRepository

/**
 * Created by Kalpesh Kundanani on 03/08/22
 */
class FetchUpcomingOrdersRepositoryImpl(private val networkClient: NetworkClient): FetchUpcomingOrdersRepository {
    override suspend fun fetchUpcomingOrders(hubCode: String): BaseResponse<UpcomingOrdersModel?> {
        return networkClient.fetchUpcomingOrders(hubCode)
    }
}