package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.login.AppConfigurationData
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.FetchAppSettingsRepository

class FetchAppSettingsRepositoryImpl(private val networkClient: NetworkClient) :
    FetchAppSettingsRepository {
    override suspend fun fetchAppSettings(workerId: String): BaseResponse<AppConfigurationData> {
        return networkClient.fetchAppSetting(workerId)
    }
}