package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.checkout.CheckoutRequest
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.CheckoutRepository

class CheckoutRepositoryImpl(private val networkClient: NetworkClient) : CheckoutRepository {
    override suspend fun checkoutRider(
        workerId: String,
        checkoutRequest: CheckoutRequest
    ): BaseResponse<Boolean?> {
        return networkClient.checkoutRider(workerId, checkoutRequest)
    }
}