package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.network.model.checkin.CheckInRequest
import com.shipsy.ondemand.riderapp.framework.network.model.login.RiderStateResponse
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.CheckInRepository

class CheckInRepositoryImpl(private val networkClient: NetworkClient) : CheckInRepository {
    override suspend fun checkInRider(workerId: String, request: CheckInRequest): RiderStateResponse? {
        return networkClient.checkIn(workerId, request)
    }
}