package com.shipsy.ondemand.riderapp.domain.repository

import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementListRequest
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.CashSettlementRequest
import com.shipsy.ondemand.riderapp.framework.data.codsettlement.SettlementData
import com.shipsy.ondemand.riderapp.framework.network.model.BaseResponse
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.CreateQrCodeRequestBody
import com.shipsy.ondemand.riderapp.framework.network.model.codsettlement.CreateQrCodeResponse
import com.shipsy.ondemand.riderapp.interactor.NetworkClient
import com.shipsy.ondemand.riderapp.interactor.repository.CODSettlementRepository

/**
 * Created by Kalpesh Kundanani on 23/09/22
 */
class CODSettlementRepositoryImpl(private val networkClient: NetworkClient) : CODSettlementRepository {
    override suspend fun fetchCodTasks(body: CashSettlementListRequest): BaseResponse<SettlementData> {
        return networkClient.fetchCodTasks(body)
    }

    override suspend fun postCashSettlementRequest(body: List<CashSettlementRequest>): BaseResponse<Boolean?> {
        return networkClient.postCashSettlementRequest(body)
    }

    override suspend fun createQrCode(body: CreateQrCodeRequestBody): BaseResponse<CreateQrCodeResponse> {
        return networkClient.createQrCode(body)
    }
}