package com.shipsy.ondemand.riderapp.domain.mapper

import com.shipsy.ondemand.riderapp.framework.data.orderhistory.OrdersOfDate
import com.shipsy.ondemand.riderapp.shared.cache.OrderHistory

/**
 * Created by Kalpesh Kundanani on 24/01/23
 */
fun OrdersOfDate?.mapToOrderHistoryList(): List<OrderHistory> {
    if (this == null || data == null) return emptyList()
    return data.map { consignment ->
        OrderHistory(
            id = 0,
            reference_number = consignment.reference_number,
            date = date,
            order_time = consignment.orderTimeAsLong,
            order_number = consignment.order_number ?: "-",
            is_vip = consignment.is_vip,
            rider_score = consignment.rider_score ?: "-",
            customer_name = consignment.customer_name ?: "-",
            customer_address = consignment.location?.customerCompleteAddress ?: "",
            discount_type = consignment.discount_type ?: "",
            discount_amount = consignment.discount_amount?.toDoubleOrNull() ?: -1.0,
            payment_mode = consignment.payment_details?.firstOrNull()?.mode ?: "",
            bill_amount = consignment.payment_details?.firstOrNull()?.value ?: -1.0,
            cod_amount = if (consignment.is_cod == true) consignment.cod_amount ?: -1.0 else -1.0,
            is_canceled = consignment.isCanceled,
            event_details = consignment.event_details?.filterNotNull() ?: emptyList(),
            hub_name = consignment.hub_name ?: "",
            hub_code = consignment.hub_code ?: "",
            childOrderNumber = consignment.childOrderNumber,
            orderTags = consignment.orderTags,
            tip = consignment.tip,
            eligiblePayout = consignment.eligible_payout
        )
    }
}