package com.shipsy.ondemand.riderapp.domain.mapper

import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.ASSIGNED_FOR_DELIVERY
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.PICKED_UP
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.PICKUP_AWAITED
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.PICKUP_COMPLETED
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.REACHED_GATE
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.RTO_REACHED_GATE
import com.shipsy.ondemand.riderapp.domain.const.OrderStatusType.START_BIKE
import com.shipsy.ondemand.riderapp.domain.orderstatus.OrderStatus

fun String.mapToOrderStatus(showDetail: Boolean = false, isPudoFlow: Boolean = false ): OrderStatus? {
    val orderStatus = when {
        equals(REACHED_GATE, true) -> OrderStatus.REACHED_GATE
        equals(RTO_REACHED_GATE, true) -> OrderStatus.RTO_REACHED_GATE
        equals(PICKUP_AWAITED, true) -> OrderStatus.PICKUP_AWAITED
        showDetail -> when {
            equals(START_BIKE, true) -> OrderStatus.START_BIKE
            equals(ASSIGNED_FOR_DELIVERY, true) -> OrderStatus.ASSIGNED_FOR_DELIVERY
            equals(PICKUP_COMPLETED, true) -> OrderStatus.PICKUP_COMPLETED
            equals(PICKED_UP, true) -> OrderStatus.PICKED_UP
            else -> null
        }
        isPudoFlow -> when {
            equals(PICKED_UP, true) -> OrderStatus.PICKED_UP
            else -> null
        }
        else -> null
    }
    println("$this -> orderStatus: $orderStatus isPudoFlow: $isPudoFlow showDetail: $showDetail")
    return orderStatus
}