package com.shipsy.ondemand.riderapp.domain.const

/**
 * Created by Kalpesh Kundanani on 05/12/22
 */
const val DELIVERY_EVENT = "delivered"
const val REACHED_DESTINATION_EVENT = "reacheddestination"
const val UNDELIVERY_EVENT = "undelivered"
const val START_DELIVERY_EVENT = "startfordelivery"
const val RETURN_HUB_EVENT = "returntohub"
const val CURRENT_ORDER = "current_order"

sealed class DisableEventType(val event: String) {
    object DeliveryEvent : DisableEventType(event = DELIVERY_EVENT)
    object ReachedDestinationEvent : DisableEventType(event = REACHED_DESTINATION_EVENT)
    object UnDeliveryEvent : DisableEventType(event = UNDELIVERY_EVENT)
    object StartDeliveryEvent : DisableEventType(event = START_DELIVERY_EVENT)
    object ReturnHubEvent : DisableEventType(event = RETURN_HUB_EVENT)
    object CurrentOrderEvent : DisableEventType(event = CURRENT_ORDER)
}