package com.shipsy.ondemand.riderapp.cache.dao

import com.shipsy.ondemand.riderapp.firebase.FirebaseEventHandler
import com.shipsy.ondemand.riderapp.framework.network.model.riderevent.RiderEvent
import com.shipsy.ondemand.riderapp.shared.cache.AppDatabaseQueries

class RiderStateEventDao(private val dbQueries: AppDatabaseQueries) {
    suspend fun insertRiderEvent(request: RiderEvent) {
        FirebaseEventHandler.logRiderStateEvent(request.type, request.reference_number_array)
        dbQueries.insertRiderStateEvents(
            id = null,
            type = request.type,
            reference_numbers = request.reference_number_array,
            transaction_id = request.transaction_id,
            vehicle_number = request.vehicle_number,
            skip_vehicle_scan_reason = request.skip_vehicle_scan_reason,
            timestamp = request.timestamp,
            lat = request.lat,
            lng = request.lng,
            payment_details = request.payment_details,
            auto_swipe = request.auto_swipe,
            discount = request.discount,
            reason = request.reason,
            receiver_relation = request.receiver_relation,
            hu_details = request.hu_details,
            pieces_status_detail = request.pieces_status_detail,
            partialDeliveryReason = request.partial_delivery_reason,
            retryCount = 0
        )
    }

    suspend fun removeSyncedEvent(ids: List<String>) {
        dbQueries.deleteByTransactionIds(ids)
    }

    suspend fun updateTransactionCount(ids: List<String>) {
        dbQueries.updateTransactionCount(ids)
    }

    suspend fun getRiderStateEventDataItems(): List<RiderEvent> {
        return dbQueries.getRiderStateEventDataItems().executeAsList()
            .mapListOrderToRiderEventRequest()
    }

    suspend fun shouldUpdateLocalState(): Boolean {
        return dbQueries.shouldUpdateLocalState().executeAsList().isEmpty()
    }
}